/*-------------------------------------------------------*
*  Name:      3DS filter for ZModeler v1.06              *
*  Purpose:   This filter for 3d-studio files ver3 and   *
*             higher. Based on source from 3ds.txt by    *
*             Martin van Velsen                          *
*  Authors:   Martin van Velsen                          *
*              Oleg M.                                   *
*                                                        *
*  History:   23.03.2002 - Rebuild for ZModeler v1.06    *
*                                                        *
*-------------------------------------------------------*/
#include <Struct.h>
#include <3DEngine.h>

#include "var.h"


//////////////////////////////////////////////////////////////
//  DWORD Capabilities - a combination versions
DWORD CALLBACK Capabilities(long)
{
  return ZMODELER_BUILD_VERSION();
}

//////////////////////////////////////////////////////////////
//  DWORD Supports returns a combination of supported features
DWORD CALLBACK Supports(DWORD)
{
  return Z3D_PLUGSUPPORTS_IMPORT | Z3D_PLUGSUPPORTS_EXPORT;
}

//////////////////////////////////////////////////////////////
//  DWORD DynamicLoading specifies whether the dll will be
//  loaded only when it'sfunctions are needed.
//  You should NOT make it dynamic, if it is a processor-type.
DWORD CALLBACK DynamicLoading(DWORD)
{
  return 1L; // DLL will be loaded each time it is needed
}

//////////////////////////////////////////////////////////////
//  void GetFilterExtention returns a file extention for sup-
//  ported files. Used if it is an IMPORT/EXPORT type
char* CALLBACK GetFilterExtension(DWORD)
{
  return "3ds";
}

//////////////////////////////////////////////////////////////
//  void GetFilterMask returns a file-mask for CFileDilaog.
//  Used if it is an IMPORT/EXPORT type.
char* CALLBACK GetFilterMask(DWORD)
{
  return "3D Studio files (*.3ds)|*.3ds|";
}

